#include <amxmodx>
#include <engine>
#include <fakemeta>
#include <fun>
#include <hamsandwich>
#include <xs>
#include <cstrike>
#include <zombieplague>

#define AUTHOR          "FeeBro"
#define NAME            "[CSO]Skull11"
#define VERSION         "Beta"

new const WpnStr[] =		"weapon_xm1014"
new const WpnSc[] =		"events/xm1014.sc"
new const WpnList[] =		"weapon_skull11"
new const view_model[] =		"models/v_skull11.mdl"
new const player_model[] =		"models/p_skull11.mdl"
new const world_model[] =		"models/w_skull11.mdl"

new const Clip =	28
new const Hold = 	200

const Float:Reloaded =	4
const Float:Speed =	1.0
const Float:Damage_weapon =		3.5

static bool:WeaponItem[33]
static Bullet[2][33]
static WeaponKey
static Origin
static Attack

#define Skull11Weapon(%0)	(get_user_weapon(%0) == get_weaponid(WpnStr) && WeaponItem[%0])
//#define DEBUG
#if !defined DEBUG
static Weapon
#endif


public plugin_init()
{
	register_plugin(NAME, VERSION, AUTHOR)
	register_clcmd(WpnList, "hook_skull11")
	
	#if defined DEBUG
	register_clcmd("say /give", "zp_extra_item_selected")
	#else
	Weapon = zp_register_extra_item(NAME, 0, ZP_TEAM_HUMAN)
	#endif
	
	RegisterHam(Ham_Weapon_Reload, WpnStr, "WeaponReload_Pre")
	RegisterHam(Ham_Weapon_Reload, WepnStr, "WeaponReload_Post", 1)
	RegisterHam(Ham_Item_Deploy, WpnStr, "WeaponDeploy", 1)
	RegisterHam(Ham_Item_AddToPlayer, WpnStr, "WeaponAddToPlayer")
	RegisterHam(Ham_Item_PostFrame, WpnStr, "WeaponPostFrame")
	RegisterHam(Ham_Weapon_PrimaryAttack, WpnStr, "PrimaryAttack_Pre")
	RegisterHam(Ham_Weapon_PrimaryAttack, WpnStr, "PrimaryAttack_Post", 1)
	RegisterHam(Ham_TraceAttack, "worldspawn", "TraceAttack")
	RegisterHam(Ham_TakeDamage, "player", "TakeDamage")
	
	register_forward(FM_SetModel, "SetModel", 1)
	register_forward(FM_UpdateClientData, "UpdateClientData", 1)
	register_forward(FM_PlaybackEvent, "Block3DSound")
	
	WeaponKey = random(10000)
}

public plugin_precache() {
	precache_model(view_model); precache_model(player_model); precache_model(world_model)
	register_forward(FM_PrecacheEvent, "PrecacheEvent", 1)
	precache_model("sprites/640hud2.spr")
	precache_model("sprites/640hud71.spr")
	precache_sound("weapons/skull11-1.wav")
	precache_sound("weapons/skull11_draw.wav")
	precache_sound("weapons/skull11_reload.wav")
	static WPN[30]
	formatex(WPN, charsmax(WPN), "sprites/%s.txt", WeaponTxt)
	precache_generic(WPN)
}

public zp_extra_item_selected(id, item)
	#if !defined DEBUG
	if (item == Weapon)
	#endif
		Give_Skull11(id)

public Give_Skull11(id) {
	if (WeaponItem[id]) {
		if (get_user_weapon(id) != get_weaponid(WpnStr))
			fm_give_item(id, WpnStr, Clip, Hold)
		else {
			set_pdata_int(id, 376 + get_pdata_int(find_ent_by_owner(-1, WpnnStr, id), 49, 4), Hold, 5)
			set_pdata_int(find_ent_by_owner(-1, WpnStr, id), 51, Clip, 4)
		}	
		
public hook_skull11(id) engclient_cmd(id, WpnStr)
public WeaponReload_Pre(Ent) {
	if (pev_valid(Ent) != 2)
		return HAM_IGNORED
	
	if (!WeaponItem[get_pdata_cbase(Ent, 41, 4)])
		return HAM_IGNORED
	
	if (get_pdata_int(Ent, 51, 4) >= Clip || get_pdata_int(get_pdata_cbase(Ent, 41, 4), 376 + get_pdata_int(Ent, 49, 4), 5) <= 0)
		return HAM_SUPERCEDE	

	return HAM_HANDLED
}
	
public WeaponReload_Post(Ent) {
	new id = get_pdata_cbase(Ent, 41, 4)
	if (!WeaponItem[id])
		return HAM_IGNORED
	
	if (get_pdata_int(Ent, 51, 4) >= Clip || get_pdata_int(id, 376 + get_pdata_int(Ent, 49, 4), 5) <= 0)
		return HAM_SUPERCEDE
	
	WeaponAnim(id, 1)
	set_pdata_float(id, 83, ReloadTime, 5)
	set_pdata_int(Ent, 54, 1, 4)
	return HAM_SUPERCEDE
}

public WeaponDeploy(Ent) {
	if (!pev_valid(Ent))
		return HAM_IGNORED
	
	new id = get_pdata_cbase(Ent, 41 , 4)
	
	if (!WeaponItem[id])
		return HAM_IGNORED
		
	set_pev(id, pev_viewmodel2, Weapon_v)
	set_pev(id, pev_weaponmodel2, Weapon_p)
	return HAM_HANDLED
}

public WeaponAddToPlayer(Ent, id) {
	if (!pev_valid(Ent) || !is_user_connected(id))
		return HAM_IGNORED
	
	if (pev(Ent, pev_impulse ) == WeaponKey) {
		set_pdata_int(id, 376 + get_pdata_int(engfunc(EngFunc_FindEntityByString, Ent, "classname", WpnStr), 49, 4), Bullet[1][id], 5)
		set_pdata_int(Ent, 51, Bullet[0][id], 4)
		WeaponItem[id] = true
	}
	// http://wiki.amxmodx.org/CS_WeaponList_Message_Dump
	message_begin(MSG_ONE, get_user_msgid("WeaponList"), _, id)
	write_string(WeaponItem[id] ? WpnList : WpnStr)	
	write_byte(5)
	write_byte(32)
	write_byte(-1)
	write_byte(-1)
	write_byte(0)
	write_byte(12)
	write_byte(5)
	write_byte(0)
	message_end() 
	return HAM_IGNORED
}

public WeaponPostFrame(Ent) {
	if (!pev_valid(Ent))
		return HAM_IGNORED
		
	static id; id = get_pdata_cbase(Ent, 41, 4)
		
	if (!WeaponItem[id])
		return HAM_IGNORED
		
	static weaponid; weaponid = 376 + get_pdata_int(Ent, 49, 4)
	if (get_pdata_int(Ent, 54, 4) && get_pdata_float(id, 83, 5) <= ReloadTime) {		
		static ammo; ammo = min(Clip - get_pdata_int(Ent, 51, 4), get_pdata_int(id, weaponid, 5))		
		set_pdata_int(Ent, 51, get_pdata_int(Ent, 51, 4) + ammo, 4)
		set_pdata_int(id, weaponid, get_pdata_int(id, weaponid, 5) - ammo, 5)
		set_pdata_int(Ent, 54, 0, 4)
	}
	static Float:fDelay; fDelay = get_pdata_float(Ent, 46, 4) * fire_speed
	if (fDelay > 0.0 ) set_pdata_float(Ent, 46, fDelay, 4)
	return HAM_HANDLED
}

public PrimaryAttack_Pre(Ent) {
	if (!pev_valid(Ent))
		return HAM_IGNORED
		
	static id; id = get_pdata_cbase(Ent, 41, 4)
	
	if (!WeaponItem[id])
		return HAM_IGNORED
	
	if (get_pdata_int(Ent, 51, 4) <= 0)
		return HAM_IGNORED
	
	static End[3]
	get_user_origin(id, End, 3)	
	LaserBeam(id, End, 1, 1)	
	WeaponAnim(id, 4)
	emit_sound(id, CHAN_WEAPON, "weapons/ethereal-1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM )
	wAttack = true
	return HAM_HANDLED
}

public PrimaryAttack_Post(Ent) {
	if (!pev_valid(Ent))
		return HAM_IGNORED
		
	static id; id = get_pdata_cbase(Ent, 41, 4)
	
	if (!WeaponItem[id])
		return HAM_IGNORED
	
	set_pev(id, pev_punchangle, 0.0)
	wAttack = false
	return HAM_HANDLED
}

public TraceAttack(victim, attacker, Float:damage, Float:direction[3], tracehandle, damage_type) {
	if (!is_user_connected(attacker))
		return HAM_IGNORED
		
	if (!EtherealWeapon(attacker))
		return HAM_IGNORED
		
	static Float:End[3]
	get_tr2(tracehandle, TR_vecEndPos, End)
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_GUNSHOTDECAL)
	engfunc(EngFunc_WriteCoord, End[0])  
	engfunc(EngFunc_WriteCoord, End[1])  
	engfunc(EngFunc_WriteCoord, End[2]) 
	write_short(attacker)
	write_byte(random_num(41,45))
	message_end()
	
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(TE_WORLDDECAL)
	engfunc(EngFunc_WriteCoord, End[0])  
	engfunc(EngFunc_WriteCoord, End[1])  
	engfunc(EngFunc_WriteCoord, End[2]) 
	write_byte(random_num(41,45))
	message_end()
	return HAM_IGNORED
}

public TakeDamage(victim, weapon, attacker, Float:damage, damagebits) {
	if (!is_user_alive(attacker) || attacker == victim)
		return HAM_IGNORED
		
	if (!EtherealWeapon(attacker))
		return HAM_IGNORED
	
	SetHamParamFloat(4, damage * wdamage)
	return HAM_HANDLED
}

public SetModel(Ent, Model[]) {
	if (!pev_valid(Ent))
		return FMRES_IGNORED
	
	static ClassName[32]
	entity_get_string(Ent, EV_SZ_classname, ClassName, charsmax(ClassName))
	
	if (!equal(ClassName, "weaponbox" ) ||  !equali(Model, "models/w_mp5.mdl"))
		return FMRES_IGNORED
	
	new id = entity_get_edict(Ent, EV_ENT_owner)
	if (!WeaponItem[id])
		return FMRES_IGNORED
		
	//engfunc(EngFunc_FindEntityByString, Ent, "classname", WeaponStr)
	entity_set_int(find_ent_by_owner (-1, WeaponStr, Ent), EV_INT_impulse, WeaponKey)
	engfunc(EngFunc_SetModel, Ent, Weapon_w)
	get_user_ammo(id, get_weaponid(WeaponStr), Bullet[0][id], Bullet[1][id])
	WeaponItem[id] = false
	static s[30]
	for (new i; i <= 9; i++) {	
		formatex(s, charsmax(s), "number_%d", i)
		StatusIcon(id, s, 0, 0, 0, 0)
	}
	return FMRES_SUPERCEDE
}

public UpdateClientData(id, wtf, CD_Handle) {
	if (!is_user_alive(id) || !EtherealWeapon(id)) {
		return FMRES_IGNORED
	}	
	set_cd(CD_Handle, CD_flNextAttack, get_gametime() + 0.0001)
	return FMRES_HANDLED
}

public PrecacheEvent(type, const name[]) {
	if (equal(WeaponSc, name)) {
		wOrigin = get_orig_retval()
		return FMRES_HANDLED
	}
	return FMRES_IGNORED;
}

public Block3DSound(flags, invoker, eventid, Float:delay, Float:origin[3], Float:iangles[3], Float:fparam1, Float:fparam2, iParam1, iParam2, bParam1, bParam2) {
	if ((eventid != Origin) || !Attack)
		return FMRES_IGNORED
	
	if (!Skull11Weapon(invoker))
		return FMRES_IGNORED	
	
	if (!(1 <= invoker /*ebuy "6"*/ <=  get_maxplayers()))
		return FMRES_IGNORED

	playback_event(flags | FEV_HOSTONLY, invoker, eventid, delay, origin, iangles, fparam1, fparam2, iParam1, iParam2, bParam1, bParam2)
	return FMRES_SUPERCEDE
}

stock fm_give_item(id, const item[], clip, hold) {
	if(!is_user_alive(id)) return
	static wname[33], weapons
	weapons = get_user_weapon(id)
	get_weaponname(weapons, wname, charsmax(wname))
	engclient_cmd(id, "drop", wname)
	
	static ent
	ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, item))
	if (!pev_valid(ent)) return
	
	static Float:originF[3]
	pev(id, pev_origin, originF)
	set_pev(ent, pev_origin, originF)
	set_pev(ent, pev_spawnflags, pev(ent, pev_spawnflags) | SF_NORESPAWN)
	dllfunc(DLLFunc_Spawn, ent)
	
	static func[4]
	func[1] = hold
	func[2] = id
	func[3] = clip
	set_task(0.1, "fm_set_user_bpammo", _, func, 4)
	
	static save
	save = pev(ent, pev_solid)
	dllfunc(DLLFunc_Touch, ent, id)
	if (pev(ent, pev_solid) != save)
		return;
		
	engfunc(EngFunc_RemoveEntity, ent)
}

public fm_set_user_bpammo(func[]) { 
	new amnt = func[1]
	new id = func[2]
	new clip = func[3]
	set_pdata_int(id, 376 + get_pdata_int(find_ent_by_owner(-1, WpnStr, id), 49, 4), amnt, 5)
	set_pdata_int(find_ent_by_owner(-1, WpnStr, id), 51, clip, 4)
}

stock WeaponAnim(index, sequence) {
	entity_set_int(index, EV_INT_weaponanim, sequence)
	message_begin(MSG_ONE, SVC_WEAPONANIM, _, index)
	write_byte(sequence)
	write_byte(0)
	message_end()
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/		
	
	