#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <cstrike>

#define PLUGIN "Lifebar"
#define VERSION "1.0"
#define AUTHOR "Psycrow"

#define TEAM_MODE 		0 // 0 -    , 1 -   , 2 -   
#define ALIVE_MODE 		0 // 0 -     , 1 -   , 2 -   
#define MAX_HEALTH 		100 //   
#define MODEL_LIFEBAR 		"sprites/next21_knife_v2/lifebar.spr"

new g_maxPlayers, g_lifebar[33], g_isAlive[33], CsTeams: g_playerTeam[33]

public plugin_precache()
	precache_model(MODEL_LIFEBAR)

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
			
	register_forward(FM_AddToFullPack, "fw_AddToFullPack", 1)
	
	RegisterHam(Ham_Spawn, "player", "fw_HamSpawn", 1)	
	
	register_event("DeathMsg", "fw_DeathMsg", "a")
	register_event("Health", "fw_ChangeHealth", "be")
	
	g_maxPlayers = get_maxplayers()
		
	for(new i = 1; i <= g_maxPlayers; i++)
	{
		g_lifebar[i] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_sprite"))
		if(!pev_valid(g_lifebar[i])) continue
		
		engfunc(EngFunc_SetModel, g_lifebar[i], MODEL_LIFEBAR)
		set_pev(g_lifebar[i], pev_movetype, MOVETYPE_FOLLOW)
		set_pev(g_lifebar[i], pev_aiment, i)
		set_pev(g_lifebar[i], pev_scale, 0.15)
	}
}

public client_putinserver(id)
{
	g_isAlive[id] = 0
	g_playerTeam[id] = CS_TEAM_SPECTATOR	
}

public client_disconnect(id)
{	
	g_isAlive[id] = 0
	g_playerTeam[id] = CS_TEAM_UNASSIGNED
}

public fw_AddToFullPack(es, e, ent, host)
{
	static i
	for(i = 1; i <= g_maxPlayers; i++)
		if(g_lifebar[i] == ent)
		{				
			if(i == host || !g_isAlive[i] || (TEAM_MODE == 1 && g_playerTeam[i] != g_playerTeam[host]) || (TEAM_MODE == 2 && g_playerTeam[i] == g_playerTeam[host])
			|| (ALIVE_MODE == 1 && !g_isAlive[host]) || (ALIVE_MODE == 2 && g_isAlive[host]))
			{
				set_es(es, ES_Effects, EF_NODRAW)
				return
			}													
			static Float: fOrigin[3]
			pev(i, pev_origin, fOrigin)						
			fOrigin[2] += 30.0
			set_es(es, ES_AimEnt, 0)
			set_es(es, ES_Origin, fOrigin)
		}
}

public fw_HamSpawn(id)
{
	if(is_user_alive(id))
	{	
		g_isAlive[id] = 1
		g_playerTeam[id] = cs_get_user_team(id)
		set_pev(g_lifebar[id], pev_frame, 99.0)
	}
}

public fw_DeathMsg()
{
	static id; id = read_data(2)
	g_isAlive[id] = 0
	g_playerTeam[id] = cs_get_user_team(id)
}

public fw_ChangeHealth(id)
{
	static hp
	hp = get_user_health(id)
	if(hp > MAX_HEALTH) hp = MAX_HEALTH
	set_pev(g_lifebar[id], pev_frame, hp * 100 / MAX_HEALTH - 1.0)
}