#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
native zp_get_user_zombie(id)
native zp_register_extra_item(const name[], cost, teams)

new const ClassnameJetPack[] = "n4d_jetpack"
new const ClassnameRocket[] = "n4d_bazooka"
new const ModelVJetPack[] = "models/zs/v_jp.mdl"
new const ModelPJetPack[] = "models/zs/p_jp.mdl"
new const ModelWJetPack[] = "models/zs/w_jp.mdl"
new const ModelRocket[] = "models/rpgrocket.mdl"
new const SoundPickup[] = "items/gunpickup2.wav"
new const SoundShoot[] = "zs/at4-1.wav"
new const SoundTravel[] = "zs/bfuu.wav"
new const SoundFly[] = "zs/fly.wav"
new const SoundBlow[] = "zs/blow.wav"

new bool:bHasJetPack[33]
new Float:fJetpackFuel[33]
new Float:fLastShoot[33]
new Float:fLastEffect[33]
new SprExp, SprTrail, ItemJetPack, iAllocInfoTarget, iMaxClients, MsgSayText
new CvarMaxFuel, CvarRadius, CvarDamage, CvarSpeed, CvarCooldown, CvarRegen, CvarRocketSpeed
new Float:CMaxFuel, Float:CRadius, Float:CDamage, Float:CSpeed, Float:CCooldown, Float:CRegen, CRocketSpeed
#define IsPlayer(%0) (1<=%0<=iMaxClients)
#define ZP_TEAM_HUMAN (1<<1)
#define ZP_PLUGIN_HANDLED 97
#define PevEntType pev_flSwimTime
#define EntTypeJetPack 3904
#define EntTypeRocket 9340

//Uncomment this to draw ring effect
#define DrawRing

//Uncomment this to draw flame effect
#define DrawFlame

#if defined DrawRing
new SprRing
#endif

#if defined DrawFlame
new SprFlame
#endif

public plugin_precache()
{
	precache_sound(SoundPickup)
	precache_sound(SoundShoot)
	precache_sound(SoundTravel)
	precache_sound(SoundFly)
	precache_sound(SoundBlow)
	
	SprExp = precache_model("sprites/zerogxplode.spr")
	SprTrail = precache_model("sprites/smoke.spr")
	
	#if defined DrawFlame
	SprFlame = precache_model("sprites/xfireball3.spr")
	#endif
	
	#if defined DrawRing
	SprRing = precache_model("sprites/shockwave.spr")
	#endif
	
	precache_model(ModelVJetPack)
	precache_model(ModelPJetPack)
	precache_model(ModelWJetPack)
	precache_model(ModelRocket)
}

public plugin_init()
{
	register_plugin("New Jetpack", "0.0.1", "Bad_Bud,wbyokomo")
	
	register_event("HLTV", "OnNewRound", "a", "1=0", "2=0")
	register_logevent("OnRoundEnd", 2, "1=Round_End")
	
	RegisterHam(Ham_Killed, "player", "OnPlayerKilled")
	RegisterHam(Ham_Item_Deploy, "weapon_knife", "OnKnifeDeployPost", 1)
	
	register_forward(FM_PlayerPreThink, "OnPlayerPreThink")
	register_forward(FM_ClientDisconnect, "OnClientDisconnect")
	register_forward(FM_Touch, "OnTouch")
	
	CvarMaxFuel = register_cvar("jp_maxfuel", "250.0")
	CvarRadius = register_cvar("jp_radius", "250.0")
	CvarDamage = register_cvar("jp_damage", "600.0")
	CvarSpeed = register_cvar("jp_speed", "300.0")
	CvarCooldown = register_cvar("jp_cooldown", "7.0")
	CvarRegen = register_cvar("jp_regen", "0.5")
	CvarRocketSpeed = register_cvar("jp_rocket_speed", "1500")
	
	iMaxClients = get_maxplayers()
	MsgSayText = get_user_msgid("SayText")
	ItemJetPack = zp_register_extra_item("JetPack", 1, ZP_TEAM_HUMAN)
}

public plugin_cfg()
{
	iAllocInfoTarget = engfunc(EngFunc_AllocString, "info_target")
}

public client_putinserver(id)
{
	ResetValues(id)
}

public OnClientDisconnect(id)
{
	ResetValues(id)
}

public OnNewRound()
{
	RemoveAllJetPack()
	CMaxFuel = get_pcvar_float(CvarMaxFuel)
	CRadius = get_pcvar_float(CvarRadius)
	CDamage = get_pcvar_float(CvarDamage)
	CSpeed = get_pcvar_float(CvarSpeed)
	CCooldown = get_pcvar_float(CvarCooldown)
	CRegen = get_pcvar_float(CvarRegen)
	CRocketSpeed = get_pcvar_num(CvarRocketSpeed)
}

public OnRoundEnd()
{
	RemoveAllJetPack()
}

public OnPlayerKilled(id)
{
	if(bHasJetPack[id]) DropJetPack(id);
	
	ResetValues(id)
}

public zp_user_infected_pre(id)
{
	if(bHasJetPack[id]) DropJetPack(id);
	
	ResetValues(id)
}

public zp_extra_item_selected(id, item)
{
	if(item == ItemJetPack)
	{
		if(bHasJetPack[id])
		{
			zp_colored_print(id, "^x04[ZP]^x01 You already have this item.")
			return ZP_PLUGIN_HANDLED;
		}
		
		bHasJetPack[id] = true
		zp_colored_print(id, "^x04[ZP]^x01 You just bought a^x04 JetPack^x01, enjoy flying & killing zombies.")
		engclient_cmd(id, "weapon_knife")
	}
	
	return PLUGIN_CONTINUE;
}

public OnKnifeDeployPost(ent)
{
	if(pev_valid(ent) == 2)
	{
		static id; id = get_pdata_cbase(ent, 41, 4)
		if(is_user_alive(id) && bHasJetPack[id]) ReplaceModel(id);
	}
}

public OnPlayerPreThink(id)
{	
	if(bHasJetPack[id])
	{
		static button, flag, Float:ctime, weapon
		button = pev(id, pev_button)
		flag = pev(id, pev_flags)
		ctime = get_gametime()
		weapon = get_user_weapon(id)
		
		if((weapon == CSW_KNIFE) && (button & IN_ATTACK2) && (fLastShoot[id] < ctime))
		{
			new ent = engfunc(EngFunc_CreateNamedEntity, iAllocInfoTarget)
			if(ent)
			{				
				set_pev(ent, pev_classname, ClassnameRocket)
				engfunc(EngFunc_SetModel, ent, ModelRocket)
				static Float:vecSrc[3]
				pev(id, pev_origin, vecSrc)
				vecSrc[2] += 16.0
				engfunc(EngFunc_SetOrigin, ent, vecSrc)
				set_pev(ent, pev_movetype, MOVETYPE_FLY)
				set_pev(ent, pev_solid, SOLID_BBOX)
				set_pev(ent, pev_effects, EF_LIGHT)
				engfunc(EngFunc_SetSize, ent, Float:{0.0, 0.0, 0.0}, Float:{0.0, 0.0, 0.0})
				set_pev(ent, pev_owner, id)
				static Float:vecVelocity[3]
				velocity_by_aim(id, CRocketSpeed, vecVelocity)
				set_pev(ent, pev_velocity, vecVelocity)
				static Float:vecAngles[3]
				engfunc(EngFunc_VecToAngles, vecVelocity, vecAngles)
				set_pev(ent, pev_angles, vecAngles)
				set_pev(ent, PevEntType, EntTypeRocket)
				
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(TE_BEAMFOLLOW)
				write_short(ent)
				write_short(SprTrail)
				write_byte(40)
				write_byte(5)
				write_byte(224)
				write_byte(224)
				write_byte(255)
				write_byte(192)
				message_end()
				
				emit_sound(id, CHAN_STATIC, SoundShoot, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
				emit_sound(ent, CHAN_WEAPON, SoundTravel, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
				fLastShoot[id] = ctime+CCooldown
			}
			else
			{
				fLastShoot[id] = ctime+1.5
			}
		}
		
		if((weapon == CSW_KNIFE) && (button & IN_DUCK) && (button & IN_JUMP) && !(flag & FL_ONGROUND) && (fJetpackFuel[id] > 0.0))
		{
			static Float:vVelocity[3], Float:vAngles[3], Float:vForward[3]
			pev(id, pev_velocity, vVelocity)
			pev(id, pev_angles, vAngles)
			vAngles[2] = 0.0
			angle_vector(vAngles, ANGLEVECTOR_FORWARD, vForward)
			vAngles = vForward
			vAngles[0] *= CSpeed
			vAngles[1] *= CSpeed
			vVelocity[0] = vAngles[0]
			vVelocity[1] = vAngles[1]
			if(vVelocity[2] < 300.0) vVelocity[2] += 35.0;
			set_pev(id, pev_velocity, vVelocity)
			
			if(fLastEffect[id] < ctime)
			{
				#if defined DrawFlame
				static Float:vOrigin[3]
				pev(id, pev_origin, vOrigin)
				engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, vOrigin, 0)
				write_byte(TE_SPRITE)
				engfunc(EngFunc_WriteCoord, vOrigin[0])
				engfunc(EngFunc_WriteCoord, vOrigin[1])
				engfunc(EngFunc_WriteCoord, vOrigin[2])
				write_short(SprFlame)
				write_byte(8)
				write_byte(128)
				message_end()
				#endif
				
				if(fJetpackFuel[id] > 80.0) emit_sound(id, CHAN_STREAM, SoundFly, VOL_NORM, ATTN_NORM, 0,  PITCH_NORM);
				else emit_sound(id, CHAN_STREAM, SoundBlow, VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
				
				fLastEffect[id] = ctime+0.2
			}
			
			fJetpackFuel[id] -= 1.0
		}
		else if(!(button & IN_DUCK) && !(button & IN_JUMP) && fJetpackFuel[id] < CMaxFuel) fJetpackFuel[id] += CRegen;
	}
}

public OnTouch(ent, id)
{
	if(pev_valid(ent))
	{
		if(pev(ent, PevEntType) == EntTypeJetPack)
		{
			if(IsPlayer(id) && is_user_alive(id) && !zp_get_user_zombie(id) && !bHasJetPack[id])
			{
				engfunc(EngFunc_RemoveEntity, ent)
				bHasJetPack[id] = true
				emit_sound(id, CHAN_STATIC, SoundPickup, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
				engclient_cmd(id,"weapon_knife")
				ReplaceModel(id)
			}
		}
		else if(pev(ent, PevEntType) == EntTypeRocket)
		{
			static Float:fOrigin[3]
			pev(ent, pev_origin, fOrigin)
			
			engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, fOrigin, 0)
			write_byte(TE_EXPLOSION)
			engfunc(EngFunc_WriteCoord, fOrigin[0])
			engfunc(EngFunc_WriteCoord, fOrigin[1])
			engfunc(EngFunc_WriteCoord, fOrigin[2])
			write_short(SprExp)
			write_byte(40)
			write_byte(30)
			write_byte(10)
			message_end()
			
			#if defined DrawRing
			engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, fOrigin, 0)
			write_byte(TE_BEAMCYLINDER)
			engfunc(EngFunc_WriteCoord, fOrigin[0])
			engfunc(EngFunc_WriteCoord, fOrigin[1])
			engfunc(EngFunc_WriteCoord, fOrigin[2])
			engfunc(EngFunc_WriteCoord, fOrigin[0])
			engfunc(EngFunc_WriteCoord, fOrigin[1])
			engfunc(EngFunc_WriteCoord, fOrigin[2]+555.0)
			write_short(SprRing)
			write_byte(0)
			write_byte(1)
			write_byte(6)
			write_byte(8)
			write_byte(10)
			write_byte(224)
			write_byte(224)
			write_byte(255)
			write_byte(192)
			write_byte(5)
			message_end()
			#endif
			
			static attacker; attacker = pev(ent, pev_owner)
			if(!is_user_connected(attacker))
			{
				engfunc(EngFunc_RemoveEntity, ent)
				return FMRES_IGNORED;
			}
			
			if(pev_valid(id) && !is_user_connected(id))
			{
				static szClassname[32]
				pev(id, pev_classname, szClassname, 31)
				if(equal(szClassname, "func_breakable") && (pev(id, pev_solid) != SOLID_NOT))
				{
					dllfunc(DLLFunc_Use, id, ent)
				}
			}
			
			static victim; victim = -1
			while((victim = engfunc(EngFunc_FindEntityInSphere, victim, fOrigin, CRadius)) != 0)
			{
				if(is_user_alive(victim) && zp_get_user_zombie(victim))
				{
					static Float:originV[3], Float:dist, Float:damage
					pev(victim, pev_origin, originV)
					dist = get_distance_f(fOrigin, originV)
					damage = CDamage-(CDamage/CRadius)*dist
					if(damage > 0.0)
					{
						ExecuteHamB(Ham_TakeDamage, victim, ent, attacker, damage, DMG_BULLET)
						//client_print(attacker, print_chat, "[JpDebug] Rocket damage: %.1f", damage)
					}
				}
			}
			
			engfunc(EngFunc_RemoveEntity, ent)
		}
	}
	
	return FMRES_IGNORED;
}

ReplaceModel(id)
{
	set_pev(id, pev_viewmodel2, ModelVJetPack)
	set_pev(id, pev_weaponmodel2, ModelPJetPack)
}

DropJetPack(id)
{
	new Float:Aim[3],Float:origin[3]
	velocity_by_aim(id, 64, Aim)
	pev(id, pev_origin, origin)
	origin[0] += Aim[0]
	origin[1] += Aim[1]
	new ent = engfunc(EngFunc_CreateNamedEntity, iAllocInfoTarget)
	if(!pev_valid(ent)) return;
	
	set_pev(ent, pev_classname, ClassnameJetPack)
	engfunc(EngFunc_SetModel, ent, ModelWJetPack)
	engfunc(EngFunc_SetSize, ent, Float:{-4.0,-4.0,-4.0}, Float:{4.0,4.0,4.0})
	set_pev(ent, pev_solid, SOLID_TRIGGER)
	set_pev(ent, pev_movetype, MOVETYPE_TOSS)
	engfunc(EngFunc_SetOrigin, ent, origin)
	set_pev(ent, PevEntType, EntTypeJetPack)
}

RemoveAllJetPack()
{
	new ent = engfunc(EngFunc_FindEntityByString, -1, "classname", ClassnameJetPack)
	while(ent > 0)
	{
		engfunc(EngFunc_RemoveEntity, ent)
		ent = engfunc(EngFunc_FindEntityByString, -1, "classname", ClassnameJetPack)
	}
}

ResetValues(id)
{
	bHasJetPack[id] = false
	fJetpackFuel[id] = get_pcvar_float(CvarMaxFuel)
}

zp_colored_print(target, const message[], any:...)
{
	static buffer[512], i, argscount
	argscount = numargs()
	
	if (!target)
	{
		static iPlayers[32], iNum, j, player
		get_players(iPlayers, iNum, "ch")
		for (j = 0; j < iNum; j++)
		{
			player = iPlayers[j]
			static changed[5], changedcount
			changedcount = 0
			
			for (i = 2; i < argscount; i++)
			{
				if (getarg(i) == LANG_PLAYER)
				{
					setarg(i, 0, player)
					changed[changedcount] = i
					changedcount++
				}
			}
			
			vformat(buffer, charsmax(buffer), message, 3)
			message_begin(MSG_ONE_UNRELIABLE, MsgSayText, _, player)
			write_byte(player)
			write_string(buffer)
			message_end()
			
			for (i = 0; i < changedcount; i++) setarg(changed[i], 0, LANG_PLAYER);
		}
	}
	else
	{
		vformat(buffer, charsmax(buffer), message, 3)
		message_begin(MSG_ONE, MsgSayText, _, target)
		write_byte(target)
		write_string(buffer)
		message_end()
	}
}
